/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.fetchWork;
import org.apache.hadoop.hive.ql.plan.partitionDesc;
import org.apache.hadoop.hive.ql.plan.tableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public class FetchOperator {
    protected transient Log LOG = LogFactory.getLog((String)this.getClass().getName());
    protected transient SessionState.LogHelper console = new SessionState.LogHelper(this.LOG);
    private fetchWork work;
    private int splitNum;
    private RecordReader<WritableComparable, Writable> currRecReader;
    private InputSplit[] inputSplits;
    private InputFormat inputFormat;
    private JobConf job;
    private WritableComparable key;
    private Writable value;
    private Deserializer serde;
    private Iterator<Path> iterPath;
    private Iterator<partitionDesc> iterPartDesc;
    private Path currPath;
    private partitionDesc currPart;
    private tableDesc currTbl;
    private boolean tblDataDone;
    private StructObjectInspector rowObjectInspector;
    private Object[] rowWithPart;
    private static Map<Class, InputFormat<WritableComparable, Writable>> inputFormats = new HashMap<Class, InputFormat<WritableComparable, Writable>>();

    public FetchOperator(fetchWork work, JobConf job) {
        this.work = work;
        this.job = job;
        this.currRecReader = null;
        this.currPath = null;
        this.currTbl = null;
        this.currPart = null;
        this.iterPath = null;
        this.iterPartDesc = null;
        this.tblDataDone = false;
        this.rowWithPart = new Object[2];
    }

    static InputFormat<WritableComparable, Writable> getInputFormatFromCache(Class inputFormatClass, Configuration conf) throws IOException {
        if (!inputFormats.containsKey(inputFormatClass)) {
            try {
                InputFormat newInstance = (InputFormat)ReflectionUtils.newInstance((Class)inputFormatClass, (Configuration)conf);
                inputFormats.put(inputFormatClass, (InputFormat<WritableComparable, Writable>)newInstance);
            }
            catch (Exception e) {
                throw new IOException("Cannot create an instance of InputFormat class " + inputFormatClass.getName() + " as specified in mapredWork!");
            }
        }
        return inputFormats.get(inputFormatClass);
    }

    private void setPrtnDesc() throws Exception {
        String[] partKeys;
        ArrayList<String> partNames = new ArrayList<String>();
        ArrayList<String> partValues = new ArrayList<String>();
        String pcols = this.currPart.getTableDesc().getProperties().getProperty("partition_columns");
        LinkedHashMap<String, String> partSpec = this.currPart.getPartSpec();
        ArrayList<ObjectInspector> partObjectInspectors = new ArrayList<ObjectInspector>();
        for (String key : partKeys = pcols.trim().split("/")) {
            partNames.add(key);
            partValues.add(partSpec.get(key));
            partObjectInspectors.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        }
        StandardStructObjectInspector partObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(partNames, partObjectInspectors);
        this.rowObjectInspector = (StructObjectInspector)this.serde.getObjectInspector();
        this.rowWithPart[1] = partValues;
        this.rowObjectInspector = ObjectInspectorFactory.getUnionStructObjectInspector(Arrays.asList(this.rowObjectInspector, partObjectInspector));
    }

    private void getNextPath() throws Exception {
        if (this.iterPath == null) {
            if (this.work.getTblDir() != null) {
                if (!this.tblDataDone) {
                    this.currPath = this.work.getTblDirPath();
                    this.currTbl = this.work.getTblDesc();
                    FileSystem fs = this.currPath.getFileSystem((Configuration)this.job);
                    if (fs.exists(this.currPath)) {
                        FileStatus[] fStats;
                        for (FileStatus fStat : fStats = fs.listStatus(this.currPath)) {
                            if (fStat.getLen() <= 0L) continue;
                            this.tblDataDone = true;
                            break;
                        }
                    }
                    if (!this.tblDataDone) {
                        this.currPath = null;
                    }
                    return;
                }
                this.currTbl = null;
                this.currPath = null;
                return;
            }
            this.iterPath = fetchWork.convertStringToPathArray(this.work.getPartDir()).iterator();
            this.iterPartDesc = this.work.getPartDesc().iterator();
        }
        while (this.iterPath.hasNext()) {
            FileStatus[] fStats;
            Path nxt = this.iterPath.next();
            partitionDesc prt = this.iterPartDesc.next();
            FileSystem fs = nxt.getFileSystem((Configuration)this.job);
            if (!fs.exists(nxt)) continue;
            for (FileStatus fStat : fStats = fs.listStatus(nxt)) {
                if (fStat.getLen() <= 0L) continue;
                this.currPath = nxt;
                this.currPart = prt;
                return;
            }
        }
    }

    private RecordReader<WritableComparable, Writable> getRecordReader() throws Exception {
        if (this.currPath == null) {
            this.getNextPath();
            if (this.currPath == null) {
                return null;
            }
            this.job.set("mapred.input.dir", StringUtils.escapeString((String)this.currPath.toString()));
            tableDesc tmp = this.currTbl;
            if (tmp == null) {
                tmp = this.currPart.getTableDesc();
            }
            this.inputFormat = FetchOperator.getInputFormatFromCache(tmp.getInputFileFormatClass(), (Configuration)this.job);
            this.inputSplits = this.inputFormat.getSplits(this.job, 1);
            this.splitNum = 0;
            this.serde = tmp.getDeserializerClass().newInstance();
            this.serde.initialize((Configuration)this.job, tmp.getProperties());
            this.LOG.debug((Object)("Creating fetchTask with deserializer typeinfo: " + this.serde.getObjectInspector().getTypeName()));
            this.LOG.debug((Object)("deserializer properties: " + tmp.getProperties()));
            if (!this.tblDataDone) {
                this.setPrtnDesc();
            }
        }
        if (this.splitNum >= this.inputSplits.length) {
            if (this.currRecReader != null) {
                this.currRecReader.close();
                this.currRecReader = null;
            }
            this.currPath = null;
            return this.getRecordReader();
        }
        this.currRecReader = this.inputFormat.getRecordReader(this.inputSplits[this.splitNum++], this.job, Reporter.NULL);
        this.key = (WritableComparable)this.currRecReader.createKey();
        this.value = (Writable)this.currRecReader.createValue();
        return this.currRecReader;
    }

    public InspectableObject getNextRow() throws IOException {
        try {
            boolean ret;
            if (this.currRecReader == null) {
                this.currRecReader = this.getRecordReader();
                if (this.currRecReader == null) {
                    return null;
                }
            }
            if (ret = this.currRecReader.next((Object)this.key, (Object)this.value)) {
                if (this.tblDataDone) {
                    Object obj = this.serde.deserialize(this.value);
                    return new InspectableObject(obj, this.serde.getObjectInspector());
                }
                this.rowWithPart[0] = this.serde.deserialize(this.value);
                return new InspectableObject(this.rowWithPart, this.rowObjectInspector);
            }
            this.currRecReader.close();
            this.currRecReader = null;
            this.currRecReader = this.getRecordReader();
            if (this.currRecReader == null) {
                return null;
            }
            return this.getNextRow();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void clearFetchContext() throws HiveException {
        try {
            if (this.currRecReader != null) {
                this.currRecReader.close();
                this.currRecReader = null;
            }
        }
        catch (Exception e) {
            throw new HiveException("Failed with exception " + e.getMessage() + StringUtils.stringifyException((Throwable)e));
        }
    }

    public ObjectInspector getOutputObjectInspector() throws HiveException {
        try {
            if (this.work.getTblDir() != null) {
                tableDesc tbl = this.work.getTblDesc();
                Deserializer serde = tbl.getDeserializerClass().newInstance();
                serde.initialize((Configuration)this.job, tbl.getProperties());
                return serde.getObjectInspector();
            }
            List<partitionDesc> listParts = this.work.getPartDesc();
            this.currPart = listParts.get(0);
            this.serde = this.currPart.getTableDesc().getDeserializerClass().newInstance();
            this.serde.initialize((Configuration)this.job, this.currPart.getTableDesc().getProperties());
            this.setPrtnDesc();
            this.currPart = null;
            return this.rowObjectInspector;
        }
        catch (Exception e) {
            throw new HiveException("Failed with exception " + e.getMessage() + StringUtils.stringifyException((Throwable)e));
        }
    }
}

