/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectValue;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.mapJoinDesc;
import org.apache.hadoop.hive.ql.plan.tableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.util.ReflectionUtils;

public class MapJoinOperator
extends CommonJoinOperator<mapJoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)MapJoinOperator.class.getName());
    protected transient Map<Byte, List<ExprNodeEvaluator>> joinKeys;
    protected transient Map<Byte, List<ObjectInspector>> joinKeysObjectInspectors;
    protected transient Map<Byte, List<ObjectInspector>> joinKeysStandardObjectInspectors;
    private transient int posBigTable;
    transient int mapJoinRowsKey;
    protected transient Map<Byte, HashMapWrapper<MapJoinObjectKey, MapJoinObjectValue>> mapJoinTables;
    private static final transient String[] fatalErrMsg = new String[]{null, "Mapside join size exceeds hive.mapjoin.maxsize. Please increase that or remove the mapjoin hint."};
    static transient Map<Integer, MapJoinObjectCtx> mapMetadata = new HashMap<Integer, MapJoinObjectCtx>();
    static transient int nextVal = 0;
    transient boolean firstRow;
    transient int metadataKeyTag;
    transient int[] metadataValueTag;
    transient List<File> hTables;
    transient int numMapRowsRead;
    transient int heartbeatInterval;
    transient int maxMapJoinSize;

    public static Map<Integer, MapJoinObjectCtx> getMapMetadata() {
        return mapMetadata;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        int pos;
        super.initializeOp(hconf);
        this.numMapRowsRead = 0;
        this.firstRow = true;
        this.heartbeatInterval = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVESENDHEARTBEAT);
        this.maxMapJoinSize = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEMAXMAPJOINSIZE);
        this.joinKeys = new HashMap<Byte, List<ExprNodeEvaluator>>();
        this.populateJoinKeyValue(this.joinKeys, ((mapJoinDesc)this.conf).getKeys());
        this.joinKeysObjectInspectors = MapJoinOperator.getObjectInspectorsFromEvaluators(this.joinKeys, this.inputObjInspectors);
        this.joinKeysStandardObjectInspectors = MapJoinOperator.getStandardObjectInspectors(this.joinKeysObjectInspectors);
        this.posBigTable = ((mapJoinDesc)this.conf).getPosBigTable();
        this.metadataValueTag = new int[this.numAliases];
        for (pos = 0; pos < this.numAliases; ++pos) {
            this.metadataValueTag[pos] = -1;
        }
        this.mapJoinTables = new HashMap<Byte, HashMapWrapper<MapJoinObjectKey, MapJoinObjectValue>>();
        this.hTables = new ArrayList<File>();
        for (pos = 0; pos < this.numAliases; ++pos) {
            if (pos == this.posBigTable) continue;
            int cacheSize = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEMAPJOINCACHEROWS);
            HashMapWrapper hashTable = new HashMapWrapper(cacheSize);
            this.mapJoinTables.put((byte)pos, hashTable);
        }
        this.storage.put((byte)this.posBigTable, new RowContainer());
        this.mapJoinRowsKey = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEMAPJOINROWSIZE);
        List<? extends StructField> structFields = ((StructObjectInspector)this.outputObjInspector).getAllStructFieldRefs();
        if (((mapJoinDesc)this.conf).getOutputColumnNames().size() < structFields.size()) {
            ArrayList<ObjectInspector> structFieldObjectInspectors = new ArrayList<ObjectInspector>();
            for (Byte alias : order) {
                int sz = ((mapJoinDesc)this.conf).getExprs().get(alias).size();
                List<Integer> retained = ((mapJoinDesc)this.conf).getRetainList().get(alias);
                for (int i = 0; i < sz; ++i) {
                    int pos2 = retained.get(i);
                    structFieldObjectInspectors.add(structFields.get(pos2).getFieldObjectInspector());
                }
            }
            this.outputObjInspector = ObjectInspectorFactory.getStandardStructObjectInspector(((mapJoinDesc)this.conf).getOutputColumnNames(), structFieldObjectInspectors);
        }
        this.initializeChildren(hconf);
    }

    @Override
    protected void fatalErrorMessage(StringBuffer errMsg, long counterCode) {
        errMsg.append("Operator " + this.getOperatorId() + " (id=" + this.id + "): " + fatalErrMsg[(int)counterCode]);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            this.alias = (byte)tag;
            if (this.lastAlias == null || !this.lastAlias.equals(this.alias)) {
                this.nextSz = this.joinEmitInterval;
            }
            ArrayList<Object> key = MapJoinOperator.computeValues(row, this.joinKeys.get(this.alias), this.joinKeysObjectInspectors.get(this.alias));
            ArrayList<Object> value = MapJoinOperator.computeValues(row, (List)this.joinValues.get(this.alias), (List)this.joinValuesObjectInspectors.get(this.alias));
            if (tag != this.posBigTable) {
                if (this.firstRow) {
                    this.metadataKeyTag = nextVal++;
                    tableDesc keyTableDesc = ((mapJoinDesc)this.conf).getKeyTblDesc();
                    SerDe keySerializer = (SerDe)ReflectionUtils.newInstance(keyTableDesc.getDeserializerClass(), null);
                    keySerializer.initialize(null, keyTableDesc.getProperties());
                    mapMetadata.put(this.metadataKeyTag, new MapJoinObjectCtx(ObjectInspectorUtils.getStandardObjectInspector(keySerializer.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE), keySerializer));
                    this.firstRow = false;
                }
                ++this.numMapRowsRead;
                if (this.numMapRowsRead % this.heartbeatInterval == 0 && this.reporter != null) {
                    this.reporter.progress();
                }
                if (this.numMapRowsRead > this.maxMapJoinSize && this.reporter != null && this.counterNameToEnum != null) {
                    LOG.warn((Object)"Too many rows in map join tables. Fatal error counter will be incremented!!");
                    this.incrCounter(fatalErrorCntr, 1L);
                    fatalError = true;
                    return;
                }
                HashMapWrapper<MapJoinObjectKey, MapJoinObjectValue> hashTable = this.mapJoinTables.get(this.alias);
                MapJoinObjectKey keyMap = new MapJoinObjectKey(this.metadataKeyTag, key);
                MapJoinObjectValue o = hashTable.get(keyMap);
                RowContainer<ArrayList<Object>> res = null;
                boolean needNewKey = true;
                if (o == null) {
                    res = new RowContainer<ArrayList<Object>>();
                    res.add(value);
                } else {
                    res = o.getObj();
                    res.add(value);
                    if (hashTable.cacheSize() > 0) {
                        o.setObj(res);
                        needNewKey = false;
                    }
                }
                if (this.metadataValueTag[tag] == -1) {
                    ++nextVal;
                    tableDesc valueTableDesc = ((mapJoinDesc)this.conf).getValueTblDescs().get(tag);
                    SerDe valueSerDe = (SerDe)ReflectionUtils.newInstance(valueTableDesc.getDeserializerClass(), null);
                    valueSerDe.initialize(null, valueTableDesc.getProperties());
                    mapMetadata.put(this.metadataValueTag[tag], new MapJoinObjectCtx(ObjectInspectorUtils.getStandardObjectInspector(valueSerDe.getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE), valueSerDe));
                }
                if (needNewKey) {
                    MapJoinObjectKey keyObj = new MapJoinObjectKey(this.metadataKeyTag, key);
                    MapJoinObjectValue valueObj = new MapJoinObjectValue(this.metadataValueTag[tag], res);
                    if (res.size() > this.mapJoinRowsKey && res.size() % 100 == 0) {
                        LOG.warn((Object)("Number of values for a given key " + keyObj + " are " + res.size()));
                        LOG.warn((Object)("used memory " + Runtime.getRuntime().totalMemory()));
                    }
                    hashTable.put(keyObj, valueObj);
                }
                return;
            }
            ((RowContainer)this.storage.get(this.alias)).add(value);
            for (Byte pos : order) {
                if (pos.intValue() == tag) continue;
                MapJoinObjectKey keyMap = new MapJoinObjectKey(this.metadataKeyTag, key);
                MapJoinObjectValue o = this.mapJoinTables.get(pos).get(keyMap);
                if (o == null) {
                    this.storage.put(pos, this.dummyObjVectors[pos.intValue()]);
                    continue;
                }
                this.storage.put(pos, o.getObj());
            }
            this.checkAndGenObject();
            ((RowContainer)this.storage.get(this.alias)).clear();
            for (Byte pos : order) {
                if (pos.intValue() == tag) continue;
                this.storage.put(pos, null);
            }
        }
        catch (SerDeException e) {
            e.printStackTrace();
            throw new HiveException(e);
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        for (HashMapWrapper<MapJoinObjectKey, MapJoinObjectValue> hashTable : this.mapJoinTables.values()) {
            hashTable.close();
        }
    }

    @Override
    public String getName() {
        return "MAPJOIN";
    }

    @Override
    public int getType() {
        return 1;
    }

    public static class MapJoinObjectCtx {
        ObjectInspector standardOI;
        SerDe serde;

        public MapJoinObjectCtx(ObjectInspector standardOI, SerDe serde) {
            this.standardOI = standardOI;
            this.serde = serde;
        }

        public ObjectInspector getStandardOI() {
            return this.standardOI;
        }

        public SerDe getSerDe() {
            return this.serde;
        }
    }
}

