/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.CollectOperator;
import org.apache.hadoop.hive.ql.exec.ExtractOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.ForwardOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDTFOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.plan.collectDesc;
import org.apache.hadoop.hive.ql.plan.extractDesc;
import org.apache.hadoop.hive.ql.plan.fileSinkDesc;
import org.apache.hadoop.hive.ql.plan.filterDesc;
import org.apache.hadoop.hive.ql.plan.forwardDesc;
import org.apache.hadoop.hive.ql.plan.groupByDesc;
import org.apache.hadoop.hive.ql.plan.joinDesc;
import org.apache.hadoop.hive.ql.plan.lateralViewJoinDesc;
import org.apache.hadoop.hive.ql.plan.limitDesc;
import org.apache.hadoop.hive.ql.plan.mapJoinDesc;
import org.apache.hadoop.hive.ql.plan.reduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.scriptDesc;
import org.apache.hadoop.hive.ql.plan.selectDesc;
import org.apache.hadoop.hive.ql.plan.tableScanDesc;
import org.apache.hadoop.hive.ql.plan.udtfDesc;
import org.apache.hadoop.hive.ql.plan.unionDesc;

public class OperatorFactory {
    public static ArrayList<opTuple> opvec = new ArrayList();

    public static <T extends Serializable> Operator<T> get(Class<T> opClass) {
        for (opTuple o : opvec) {
            if (o.descClass != opClass) continue;
            try {
                Operator op = o.opClass.newInstance();
                op.initializeCounters();
                return op;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("No operator for descriptor class " + opClass.getName());
    }

    public static <T extends Serializable> Operator<T> get(Class<T> opClass, RowSchema rwsch) {
        Operator<T> ret = OperatorFactory.get(opClass);
        ret.setSchema(rwsch);
        return ret;
    }

    public static <T extends Serializable> Operator<T> get(T conf, Operator<? extends Serializable> ... oplist) {
        Operator<?> ret = OperatorFactory.get(conf.getClass());
        ret.setConf(conf);
        if (oplist.length == 0) {
            return ret;
        }
        ArrayList<Operator<? extends Serializable>> clist = new ArrayList<Operator<? extends Serializable>>();
        for (Operator<? extends Serializable> op : oplist) {
            clist.add(op);
        }
        ret.setChildOperators(clist);
        for (Operator<? extends Serializable> op : oplist) {
            List<Operator<? extends Serializable>> parents = op.getParentOperators();
            if (parents == null) {
                parents = new ArrayList<Operator<Serializable>>();
            }
            parents.add(ret);
            op.setParentOperators(parents);
        }
        return ret;
    }

    public static <T extends Serializable> Operator<T> get(T conf, RowSchema rwsch, Operator ... oplist) {
        Operator<T> ret = OperatorFactory.get(conf, oplist);
        ret.setSchema(rwsch);
        return ret;
    }

    public static <T extends Serializable> Operator<T> getAndMakeChild(T conf, Operator ... oplist) {
        Operator<?> ret = OperatorFactory.get(conf.getClass());
        ret.setConf(conf);
        if (oplist.length == 0) {
            return ret;
        }
        for (Operator op : oplist) {
            List<Operator<? extends Serializable>> children = op.getChildOperators();
            if (children == null) {
                children = new ArrayList<Operator<Serializable>>();
            }
            children.add(ret);
            op.setChildOperators(children);
        }
        ArrayList<Operator<? extends Serializable>> parent = new ArrayList<Operator<? extends Serializable>>();
        for (Operator op : oplist) {
            parent.add(op);
        }
        ret.setParentOperators(parent);
        return ret;
    }

    public static <T extends Serializable> Operator<T> getAndMakeChild(T conf, RowSchema rwsch, Operator ... oplist) {
        Operator<T> ret = OperatorFactory.getAndMakeChild(conf, oplist);
        ret.setSchema(rwsch);
        return ret;
    }

    static {
        opvec.add(new opTuple<filterDesc>(filterDesc.class, FilterOperator.class));
        opvec.add(new opTuple<selectDesc>(selectDesc.class, SelectOperator.class));
        opvec.add(new opTuple<forwardDesc>(forwardDesc.class, ForwardOperator.class));
        opvec.add(new opTuple<fileSinkDesc>(fileSinkDesc.class, FileSinkOperator.class));
        opvec.add(new opTuple<collectDesc>(collectDesc.class, CollectOperator.class));
        opvec.add(new opTuple<scriptDesc>(scriptDesc.class, ScriptOperator.class));
        opvec.add(new opTuple<reduceSinkDesc>(reduceSinkDesc.class, ReduceSinkOperator.class));
        opvec.add(new opTuple<extractDesc>(extractDesc.class, ExtractOperator.class));
        opvec.add(new opTuple<groupByDesc>(groupByDesc.class, GroupByOperator.class));
        opvec.add(new opTuple<joinDesc>(joinDesc.class, JoinOperator.class));
        opvec.add(new opTuple<mapJoinDesc>(mapJoinDesc.class, MapJoinOperator.class));
        opvec.add(new opTuple<limitDesc>(limitDesc.class, LimitOperator.class));
        opvec.add(new opTuple<tableScanDesc>(tableScanDesc.class, TableScanOperator.class));
        opvec.add(new opTuple<unionDesc>(unionDesc.class, UnionOperator.class));
        opvec.add(new opTuple<udtfDesc>(udtfDesc.class, UDTFOperator.class));
        opvec.add(new opTuple<lateralViewJoinDesc>(lateralViewJoinDesc.class, LateralViewJoinOperator.class));
    }

    public static final class opTuple<T extends Serializable> {
        public Class<T> descClass;
        public Class<? extends Operator<T>> opClass;

        public opTuple(Class<T> descClass, Class<? extends Operator<T>> opClass) {
            this.descClass = descClass;
            this.opClass = opClass;
        }
    }
}

