/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.groupByDesc;
import org.apache.hadoop.hive.ql.plan.mapredWork;
import org.apache.hadoop.hive.ql.plan.partitionDesc;
import org.apache.hadoop.hive.ql.plan.tableDesc;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public class Utilities {
    private static Map<String, mapredWork> gWorkMap = Collections.synchronizedMap(new HashMap());
    private static final Log LOG = LogFactory.getLog((String)Utilities.class.getName());
    public static tableDesc defaultTd = PlanUtils.getDefaultTableDesc("1");
    public static final int newLineCode = 10;
    public static final int tabCode = 9;
    public static final int ctrlaCode = 1;
    public static final String INDENT = "  ";
    public static String nullStringStorage = "\\N";
    public static String nullStringOutput = "NULL";
    public static Random randGen = new Random();
    public static final String NSTR = "";
    private static final String tmpPrefix = "_tmp.";
    static Pattern fileNameTaskIdRegex = Pattern.compile("^.*_([0-9]*)_[0-9](\\..*)?$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearMapRedWork(Configuration job) {
        Object planPath;
        try {
            planPath = new Path(HiveConf.getVar(job, HiveConf.ConfVars.PLAN));
            FileSystem fs = FileSystem.get((Configuration)job);
            if (fs.exists(planPath)) {
                try {
                    fs.delete(planPath, true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            Map<String, mapredWork> map = gWorkMap;
            synchronized (map) {
                gWorkMap.remove(Utilities.getJobName(job));
            }
        }
        finally {
            planPath = gWorkMap;
            synchronized (planPath) {
                gWorkMap.remove(Utilities.getJobName(job));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static mapredWork getMapRedWork(Configuration job) {
        mapredWork gWork = null;
        try {
            Object object = gWorkMap;
            synchronized (object) {
                gWork = gWorkMap.get(Utilities.getJobName(job));
            }
            if (gWork != null) return gWork;
            object = Utilities.class;
            synchronized (Utilities.class) {
                mapredWork ret;
                if (gWork != null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return gWork;
                }
                FileInputStream in = new FileInputStream("HIVE_PLAN" + Utilities.sanitizedJobId(job));
                gWork = ret = Utilities.deserializeMapRedWork(in, job);
                gWork.initialize();
                gWorkMap.put(Utilities.getJobName(job), gWork);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return gWork;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static List<String> getFieldSchemaString(List<FieldSchema> fl) {
        if (fl == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (FieldSchema f : fl) {
            ret.add(f.getName() + " " + f.getType() + (f.getComment() != null ? " " + f.getComment() : NSTR));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMapRedWork(Configuration job, mapredWork w) {
        try {
            FileSystem fs = FileSystem.get((Configuration)job);
            Path planPath = new Path(HiveConf.getVar(job, HiveConf.ConfVars.SCRATCHDIR), "plan." + randGen.nextInt());
            FSDataOutputStream out = fs.create(planPath);
            Utilities.serializeMapRedWork(w, (OutputStream)out);
            HiveConf.setVar(job, HiveConf.ConfVars.PLAN, planPath.toString());
            DistributedCache.createSymlink((Configuration)job);
            String uriWithLink = planPath.toUri().toString() + "#HIVE_PLAN" + Utilities.sanitizedJobId(job);
            DistributedCache.addCacheFile((URI)new URI(uriWithLink), (Configuration)job);
            Class<Utilities> clazz = Utilities.class;
            synchronized (Utilities.class) {
                w.initialize();
                gWorkMap.put(Utilities.getJobName(job), w);
                // ** MonitorExit[var6_7] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        {
            return;
        }
    }

    public static String getJobName(Configuration job) {
        String s = HiveConf.getVar(job, HiveConf.ConfVars.HADOOPJOBNAME);
        if (s == null) {
            s = "JOB" + randGen.nextInt();
            HiveConf.setVar(job, HiveConf.ConfVars.HADOOPJOBNAME, s);
        }
        return s;
    }

    public static int sanitizedJobId(Configuration job) {
        String s = Utilities.getJobName(job);
        return s.hashCode();
    }

    public static void serializeTasks(Task<? extends Serializable> t, OutputStream out) {
        XMLEncoder e = new XMLEncoder(out);
        e.setPersistenceDelegate(PlanUtils.ExpressionTypes.class, new EnumDelegate());
        e.setPersistenceDelegate(groupByDesc.Mode.class, new EnumDelegate());
        e.setPersistenceDelegate(Operator.ProgressCounter.class, new EnumDelegate());
        e.writeObject(t);
        e.close();
    }

    public static void serializeMapRedWork(mapredWork w, OutputStream out) {
        XMLEncoder e = new XMLEncoder(out);
        e.setPersistenceDelegate(PlanUtils.ExpressionTypes.class, new EnumDelegate());
        e.setPersistenceDelegate(groupByDesc.Mode.class, new EnumDelegate());
        e.writeObject(w);
        e.close();
    }

    public static mapredWork deserializeMapRedWork(InputStream in, Configuration conf) {
        XMLDecoder d = new XMLDecoder(in, null, null, conf.getClassLoader());
        mapredWork ret = (mapredWork)d.readObject();
        d.close();
        return ret;
    }

    public static String getTaskId(Configuration hconf) {
        String taskid;
        String string = taskid = hconf == null ? null : hconf.get("mapred.task.id");
        if (taskid == null || taskid.equals(NSTR)) {
            return NSTR + randGen.nextInt();
        }
        return taskid.replaceAll("task_[0-9]+_", NSTR);
    }

    public static HashMap makeMap(Object ... olist) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        for (int i = 0; i < olist.length; i += 2) {
            ret.put(olist[i], olist[i + 1]);
        }
        return ret;
    }

    public static Properties makeProperties(String ... olist) {
        Properties ret = new Properties();
        for (int i = 0; i < olist.length; i += 2) {
            ret.setProperty(olist[i], olist[i + 1]);
        }
        return ret;
    }

    public static ArrayList makeList(Object ... olist) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int i = 0; i < olist.length; ++i) {
            ret.add(olist[i]);
        }
        return ret;
    }

    public static tableDesc getTableDesc(Table tbl) {
        return new tableDesc(tbl.getDeserializer().getClass(), tbl.getInputFormatClass(), tbl.getOutputFormatClass(), tbl.getSchema());
    }

    public static partitionDesc getPartitionDesc(Partition part) throws HiveException {
        return new partitionDesc(part);
    }

    public static void addMapWork(mapredWork mr, Table tbl, String alias, Operator<?> work) {
        mr.addMapWork(tbl.getDataLocation().getPath(), alias, work, new partitionDesc(Utilities.getTableDesc(tbl), null));
    }

    private static String getOpTreeSkel_helper(Operator<?> op, String indent) {
        if (op == null) {
            return NSTR;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(indent);
        sb.append(op.toString());
        sb.append("\n");
        if (op.getChildOperators() != null) {
            for (Operator<Serializable> child : op.getChildOperators()) {
                sb.append(Utilities.getOpTreeSkel_helper(child, indent + INDENT));
            }
        }
        return sb.toString();
    }

    public static String getOpTreeSkel(Operator<?> op) {
        return Utilities.getOpTreeSkel_helper(op, NSTR);
    }

    private static boolean isWhitespace(int c) {
        if (c == -1) {
            return false;
        }
        return Character.isWhitespace((char)c);
    }

    public static boolean contentsEqual(InputStream is1, InputStream is2, boolean ignoreWhitespace) throws IOException {
        try {
            int c2;
            int c1;
            if (is1 == is2 || is1 == null && is2 == null) {
                return true;
            }
            if (is1 == null || is2 == null) {
                return false;
            }
            do {
                c1 = is1.read();
                while (ignoreWhitespace && Utilities.isWhitespace(c1)) {
                    c1 = is1.read();
                }
                c2 = is2.read();
                while (ignoreWhitespace && Utilities.isWhitespace(c2)) {
                    c2 = is2.read();
                }
                if (c1 != -1 || c2 != -1) continue;
                return true;
            } while (c1 == c2);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String abbreviate(String str, int max) {
        str = str.trim();
        int len = str.length();
        int suffixlength = 20;
        if (len <= max) {
            return str;
        }
        suffixlength = Math.min(suffixlength, (max - 3) / 2);
        String rev = StringUtils.reverse(str);
        String suffix = WordUtils.abbreviate(rev, 0, suffixlength, NSTR);
        suffix = StringUtils.reverse(suffix);
        String prefix = StringUtils.abbreviate(str, max - suffix.length());
        return prefix + suffix;
    }

    public static streamStatus readColumn(DataInput in, OutputStream out) throws IOException {
        while (true) {
            byte b;
            try {
                b = in.readByte();
            }
            catch (EOFException e) {
                return streamStatus.EOF;
            }
            if (b == 10) {
                return streamStatus.TERMINATED;
            }
            out.write(b);
        }
    }

    public static OutputStream createCompressedStream(JobConf jc, OutputStream out) throws IOException {
        boolean isCompressed = FileOutputFormat.getCompressOutput((JobConf)jc);
        return Utilities.createCompressedStream(jc, out, isCompressed);
    }

    public static OutputStream createCompressedStream(JobConf jc, OutputStream out, boolean isCompressed) throws IOException {
        if (isCompressed) {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)jc);
            return codec.createOutputStream(out);
        }
        return out;
    }

    public static String getFileExtension(JobConf jc, boolean isCompressed) {
        if (!isCompressed) {
            return NSTR;
        }
        Class codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)jc);
        return codec.getDefaultExtension();
    }

    public static SequenceFile.Writer createSequenceWriter(JobConf jc, FileSystem fs, Path file, Class<?> keyClass, Class<?> valClass) throws IOException {
        boolean isCompressed = SequenceFileOutputFormat.getCompressOutput((JobConf)jc);
        return Utilities.createSequenceWriter(jc, fs, file, keyClass, valClass, isCompressed);
    }

    public static SequenceFile.Writer createSequenceWriter(JobConf jc, FileSystem fs, Path file, Class<?> keyClass, Class<?> valClass, boolean isCompressed) throws IOException {
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        Class codecClass = null;
        if (isCompressed) {
            compressionType = SequenceFileOutputFormat.getOutputCompressionType((JobConf)jc);
            codecClass = SequenceFileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)jc);
        }
        return SequenceFile.createWriter((FileSystem)fs, (Configuration)jc, (Path)file, keyClass, valClass, (SequenceFile.CompressionType)compressionType, codec);
    }

    public static RCFile.Writer createRCFileWriter(JobConf jc, FileSystem fs, Path file, boolean isCompressed) throws IOException {
        CompressionCodec codec = null;
        Class codecClass = null;
        if (isCompressed) {
            codecClass = FileOutputFormat.getOutputCompressorClass((JobConf)jc, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)jc);
        }
        return new RCFile.Writer(fs, (Configuration)jc, file, null, codec);
    }

    public static String realFile(String newFile, Configuration conf) throws IOException {
        Path path = new Path(newFile);
        URI pathURI = path.toUri();
        Object fs = pathURI.getScheme() == null ? FileSystem.getLocal((Configuration)conf) : path.getFileSystem(conf);
        if (!fs.exists(path)) {
            return null;
        }
        try {
            fs.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        String file = path.makeQualified((FileSystem)fs).toString();
        if (StringUtils.startsWith(file, "file:/") && !StringUtils.startsWith(file, "file:///")) {
            file = "file:///" + file.substring("file:/".length());
        }
        return file;
    }

    public static List<String> mergeUniqElems(List<String> src, List<String> dest) {
        if (dest == null) {
            return src;
        }
        if (src == null) {
            return dest;
        }
        for (int pos = 0; pos < dest.size(); ++pos) {
            if (src.contains(dest.get(pos))) continue;
            src.add(dest.get(pos));
        }
        return src;
    }

    public static Path toTempPath(Path orig) {
        if (orig.getName().indexOf(tmpPrefix) == 0) {
            return orig;
        }
        return new Path(orig.getParent(), tmpPrefix + orig.getName());
    }

    public static Path toTempPath(String orig) {
        return Utilities.toTempPath(new Path(orig));
    }

    public static boolean isTempPath(FileStatus file) {
        String name = file.getPath().getName();
        return name.startsWith("_task") || name.startsWith(tmpPrefix);
    }

    public static void rename(FileSystem fs, Path src, Path dst) throws IOException, HiveException {
        if (!fs.rename(src, dst)) {
            throw new HiveException("Unable to move: " + src + " to: " + dst);
        }
    }

    public static void renameOrMoveFiles(FileSystem fs, Path src, Path dst) throws IOException, HiveException {
        if (!fs.exists(dst)) {
            if (!fs.rename(src, dst)) {
                throw new HiveException("Unable to move: " + src + " to: " + dst);
            }
        } else {
            FileStatus[] files = fs.listStatus(src);
            for (int i = 0; i < files.length; ++i) {
                Path srcFilePath = files[i].getPath();
                String fileName = srcFilePath.getName();
                Path dstFilePath = new Path(dst, fileName);
                if (fs.exists(dstFilePath)) {
                    int suffix = 0;
                    while (fs.exists(dstFilePath = new Path(dst, fileName + "_" + ++suffix))) {
                    }
                }
                if (fs.rename(srcFilePath, dstFilePath)) continue;
                throw new HiveException("Unable to move: " + src + " to: " + dst);
            }
        }
    }

    public static String getTaskIdFromFilename(String filename) {
        Matcher m = fileNameTaskIdRegex.matcher(filename);
        if (!m.matches()) {
            LOG.warn((Object)("Unable to get task id from file name: " + filename + ". Using full filename as task id."));
            return filename;
        }
        String taskId = m.group(1);
        LOG.debug((Object)("TaskId for " + filename + " = " + taskId));
        return taskId;
    }

    public static void removeTempOrDuplicateFiles(FileSystem fs, Path path) throws IOException {
        if (path == null) {
            return;
        }
        FileStatus[] items = fs.listStatus(path);
        if (items == null) {
            return;
        }
        HashMap<String, FileStatus> taskIdToFile = new HashMap<String, FileStatus>();
        for (FileStatus one : items) {
            if (Utilities.isTempPath(one)) {
                if (fs.delete(one.getPath(), true)) continue;
                throw new IOException("Unable to delete tmp file: " + one.getPath());
            }
            String taskId = Utilities.getTaskIdFromFilename(one.getPath().getName());
            FileStatus otherFile = (FileStatus)taskIdToFile.get(taskId);
            if (otherFile == null) {
                taskIdToFile.put(taskId, one);
                continue;
            }
            if (!fs.delete(one.getPath(), true)) {
                throw new IOException("Unable to delete duplicate file: " + one.getPath() + ". Existing file: " + otherFile.getPath());
            }
            LOG.warn((Object)("Duplicate taskid file removed: " + one.getPath() + ". Existing file: " + otherFile.getPath()));
        }
    }

    public static String getNameMessage(Exception e) {
        return e.getClass().getName() + "(" + e.getMessage() + ")";
    }

    public static ClassLoader addToClassPath(ClassLoader cloader, String[] newPaths) throws Exception {
        URLClassLoader loader = (URLClassLoader)cloader;
        List<URL> curPath = Arrays.asList(loader.getURLs());
        ArrayList<URL> newPath = new ArrayList<URL>();
        for (URL onePath : curPath) {
            newPath.add(onePath);
        }
        curPath = newPath;
        for (String onestr : newPaths) {
            URL oneurl;
            if (StringUtils.indexOf(onestr, "file://") == 0) {
                onestr = StringUtils.substring(onestr, 7);
            }
            if (curPath.contains(oneurl = new File(onestr).toURL())) continue;
            curPath.add(oneurl);
        }
        return new URLClassLoader(curPath.toArray(new URL[0]), (ClassLoader)loader);
    }

    public static void removeFromClassPath(String[] pathsToRemove) throws Exception {
        Thread curThread = Thread.currentThread();
        URLClassLoader loader = (URLClassLoader)curThread.getContextClassLoader();
        HashSet<URL> newPath = new HashSet<URL>(Arrays.asList(loader.getURLs()));
        for (String onestr : pathsToRemove) {
            if (StringUtils.indexOf(onestr, "file://") == 0) {
                onestr = StringUtils.substring(onestr, 7);
            }
            URL oneurl = new File(onestr).toURL();
            newPath.remove(oneurl);
        }
        loader = new URLClassLoader(newPath.toArray(new URL[0]));
        curThread.setContextClassLoader(loader);
    }

    public static String formatBinaryString(byte[] array, int start, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < start + length; ++i) {
            sb.append("x");
            sb.append(array[i] < 0 ? array[i] + 256 : array[i] + 0);
        }
        return sb.toString();
    }

    public static List<String> getColumnNamesFromSortCols(List<Order> sortCols) {
        ArrayList<String> names = new ArrayList<String>();
        for (Order o : sortCols) {
            names.add(o.getCol());
        }
        return names;
    }

    public static List<String> getColumnNamesFromFieldSchema(List<FieldSchema> partCols) {
        ArrayList<String> names = new ArrayList<String>();
        for (FieldSchema o : partCols) {
            names.add(o.getName());
        }
        return names;
    }

    public static void validateColumnNames(List<String> colNames, List<String> checkCols) throws SemanticException {
        for (String toCheck : checkCols) {
            boolean found = false;
            for (String colName : colNames) {
                if (!toCheck.equalsIgnoreCase(colName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg());
        }
    }

    public static int getDefaultNotificationInterval(Configuration hconf) {
        Integer expInterval = Integer.decode(hconf.get("mapred.tasktracker.expiry.interval"));
        int notificationInterval = expInterval != null ? expInterval / 2 : 300000;
        return notificationInterval;
    }

    public static enum streamStatus {
        EOF,
        TERMINATED;

    }

    public static class StreamPrinter
    extends Thread {
        InputStream is;
        String type;
        PrintStream os;

        public StreamPrinter(InputStream is, String type, PrintStream os) {
            this.is = is;
            this.type = type;
            this.os = os;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                if (this.type != null) {
                    while ((line = br.readLine()) != null) {
                        this.os.println(this.type + ">" + line);
                    }
                } else {
                    while ((line = br.readLine()) != null) {
                        this.os.println(line);
                    }
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static class Tuple<T, V> {
        private T one;
        private V two;

        public Tuple(T one, V two) {
            this.one = one;
            this.two = two;
        }

        public T getOne() {
            return this.one;
        }

        public V getTwo() {
            return this.two;
        }
    }

    public static class EnumDelegate
    extends DefaultPersistenceDelegate {
        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(Enum.class, "valueOf", new Object[]{oldInstance.getClass(), ((Enum)oldInstance).name()});
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance == newInstance;
        }
    }

    public static enum ReduceField {
        KEY,
        VALUE,
        ALIAS;

    }
}

