/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import java.net.URI;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class WriteEntity {
    private Type typ;
    private Table t;
    private Partition p;
    private String d;

    public WriteEntity(Table t) {
        this.d = null;
        this.p = null;
        this.t = t;
        this.typ = Type.TABLE;
    }

    public WriteEntity(Partition p) {
        this.d = null;
        this.p = p;
        this.t = p.getTable();
        this.typ = Type.PARTITION;
    }

    public WriteEntity(String d, boolean islocal) {
        this.d = d;
        this.p = null;
        this.t = null;
        this.typ = islocal ? Type.LOCAL_DIR : Type.DFS_DIR;
    }

    public Type getType() {
        return this.typ;
    }

    public URI getLocation() throws Exception {
        if (this.typ == Type.TABLE) {
            return this.t.getDataLocation();
        }
        if (this.typ == Type.PARTITION) {
            return this.p.getDataLocation();
        }
        if (this.typ == Type.DFS_DIR || this.typ == Type.LOCAL_DIR) {
            return new URI(this.d);
        }
        return null;
    }

    public Partition getPartition() {
        return this.p;
    }

    public Table getTable() {
        return this.t;
    }

    public String toString() {
        switch (this.typ) {
            case TABLE: {
                return this.t.getDbName() + "@" + this.t.getName();
            }
            case PARTITION: {
                return this.t.getDbName() + "@" + this.t.getName() + "@" + this.p.getName();
            }
        }
        return this.d;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof WriteEntity) {
            WriteEntity ore = (WriteEntity)o;
            return this.toString().equalsIgnoreCase(ore.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static enum Type {
        TABLE,
        PARTITION,
        DFS_DIR,
        LOCAL_DIR;

    }
}

