/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.ColumnPrunerProcCtx;
import org.apache.hadoop.hive.ql.optimizer.ColumnPrunerProcFactory;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class ColumnPruner
implements Transform {
    protected ParseContext pGraphContext = null;
    private HashMap<Operator<? extends Serializable>, OpParseContext> opToParseCtxMap;

    private Operator<? extends Serializable> putOpInsertMap(Operator<? extends Serializable> op, RowResolver rr) {
        OpParseContext ctx = new OpParseContext(rr);
        this.pGraphContext.getOpParseCtx().put(op, ctx);
        return op;
    }

    @Override
    public ParseContext transform(ParseContext pactx) throws SemanticException {
        this.pGraphContext = pactx;
        this.opToParseCtxMap = this.pGraphContext.getOpParseCtx();
        ColumnPrunerProcCtx cppCtx = new ColumnPrunerProcCtx(this.opToParseCtxMap);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", "FIL%"), ColumnPrunerProcFactory.getFilterProc());
        opRules.put(new RuleRegExp("R2", "GBY%"), ColumnPrunerProcFactory.getGroupByProc());
        opRules.put(new RuleRegExp("R3", "RS%"), ColumnPrunerProcFactory.getReduceSinkProc());
        opRules.put(new RuleRegExp("R4", "SEL%"), ColumnPrunerProcFactory.getSelectProc());
        opRules.put(new RuleRegExp("R5", "JOIN%"), ColumnPrunerProcFactory.getJoinProc());
        opRules.put(new RuleRegExp("R6", "MAPJOIN%"), ColumnPrunerProcFactory.getMapJoinProc());
        opRules.put(new RuleRegExp("R7", "TS%"), ColumnPrunerProcFactory.getTableScanProc());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(ColumnPrunerProcFactory.getDefaultProc(), opRules, cppCtx);
        ColumnPrunerWalker ogw = new ColumnPrunerWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(this.pGraphContext.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return this.pGraphContext;
    }

    public static class ColumnPrunerWalker
    extends DefaultGraphWalker {
        public ColumnPrunerWalker(Dispatcher disp) {
            super(disp);
        }

        @Override
        public void walk(Node nd) throws SemanticException {
            boolean walkChildren = true;
            this.opStack.push(nd);
            if (nd instanceof SelectOperator) {
                for (Node node : nd.getChildren()) {
                    if (!(node instanceof FileSinkOperator) && !(node instanceof ScriptOperator)) continue;
                    walkChildren = false;
                }
            }
            if (nd.getChildren() == null || this.getDispatchedList().containsAll(nd.getChildren()) || !walkChildren) {
                this.dispatch(nd, this.opStack);
                this.opStack.pop();
                return;
            }
            this.getToWalk().removeAll(nd.getChildren());
            this.getToWalk().addAll(0, nd.getChildren());
            this.getToWalk().add(nd);
            this.opStack.pop();
        }
    }
}

