/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MoveTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverMergeFiles;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.exprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.ql.plan.extractDesc;
import org.apache.hadoop.hive.ql.plan.fileSinkDesc;
import org.apache.hadoop.hive.ql.plan.loadFileDesc;
import org.apache.hadoop.hive.ql.plan.mapredWork;
import org.apache.hadoop.hive.ql.plan.moveWork;
import org.apache.hadoop.hive.ql.plan.partitionDesc;
import org.apache.hadoop.hive.ql.plan.reduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.tableDesc;
import org.apache.hadoop.hive.ql.plan.tableScanDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class GenMRFileSink1
implements NodeProcessor {
    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        ParseContext parseCtx = ctx.getParseCtx();
        boolean chDir = false;
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        if (ctx.getMvTask() != null && !ctx.getMvTask().isEmpty()) {
            MoveTask mvTask;
            List<Task<? extends Serializable>> mvTasks = ctx.getMvTask();
            if ((ctx.getSeenFileSinkOps() == null || !ctx.getSeenFileSinkOps().contains((FileSinkOperator)nd)) && (mvTask = (MoveTask)this.findMoveTask(mvTasks, (FileSinkOperator)nd)) != null && !mvTask.isLocal() && (parseCtx.getConf().getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPFILES) && ((mapredWork)currTask.getWork()).getReducer() == null || parseCtx.getConf().getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPREDFILES) && ((mapredWork)currTask.getWork()).getReducer() != null)) {
                chDir = true;
            }
        }
        String finalName = this.processFS(nd, stack, opProcCtx, chDir);
        if (chDir && finalName != null) {
            this.createMergeJob((FileSinkOperator)nd, ctx, finalName);
        }
        return null;
    }

    private void createMergeJob(FileSinkOperator fsOp, GenMRProcContext ctx, String finalName) {
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        RowSchema fsRS = fsOp.getSchema();
        ArrayList<exprNodeDesc> keyCols = new ArrayList<exprNodeDesc>();
        keyCols.add(TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("rand", new exprNodeDesc[0]));
        ArrayList<exprNodeDesc> valueCols = new ArrayList<exprNodeDesc>();
        for (ColumnInfo ci : fsRS.getSignature()) {
            valueCols.add(new exprNodeColumnDesc(ci.getType(), ci.getInternalName(), ci.getTabAlias(), ci.getIsPartitionCol()));
        }
        Operator<tableScanDesc> ts_op = OperatorFactory.get(tableScanDesc.class, fsRS);
        ArrayList<String> outputColumns = new ArrayList<String>();
        for (int i = 0; i < valueCols.size(); ++i) {
            outputColumns.add(SemanticAnalyzer.getColumnInternalName(i));
        }
        reduceSinkDesc rsDesc = PlanUtils.getReduceSinkDesc(new ArrayList<exprNodeDesc>(), valueCols, outputColumns, false, -1, -1, -1);
        ReduceSinkOperator rsOp = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(rsDesc, fsRS, ts_op);
        mapredWork cplan = GenMapRedUtils.getMapRedWork();
        ParseContext parseCtx = ctx.getParseCtx();
        Task<mapredWork> mergeTask = TaskFactory.get(cplan, parseCtx.getConf(), new Task[0]);
        fileSinkDesc fsConf = (fileSinkDesc)fsOp.getConf();
        RowResolver out_rwsch = new RowResolver();
        RowResolver interim_rwsch = ctx.getParseCtx().getOpParseCtx().get(fsOp).getRR();
        Integer pos = 0;
        for (ColumnInfo colInfo : interim_rwsch.getColumnInfos()) {
            String[] info = interim_rwsch.reverseLookup(colInfo.getInternalName());
            out_rwsch.put(info[0], info[1], new ColumnInfo(pos.toString(), colInfo.getType(), info[0], colInfo.getIsPartitionCol()));
            pos = pos + 1;
        }
        Operator<extractDesc> extract = OperatorFactory.getAndMakeChild(new extractDesc(new exprNodeColumnDesc(TypeInfoFactory.stringTypeInfo, Utilities.ReduceField.VALUE.toString(), "", false)), new RowSchema(out_rwsch.getColumnInfos()), new Operator[0]);
        tableDesc ts = (tableDesc)fsConf.getTableInfo().clone();
        fsConf.getTableInfo().getProperties().remove("partition_columns");
        FileSinkOperator newOutput = (FileSinkOperator)OperatorFactory.getAndMakeChild(new fileSinkDesc(finalName, ts, parseCtx.getConf().getBoolVar(HiveConf.ConfVars.COMPRESSRESULT)), fsRS, extract);
        cplan.setReducer(extract);
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add(fsConf.getDirName());
        cplan.getPathToAliases().put(fsConf.getDirName(), aliases);
        cplan.getAliasToWork().put(fsConf.getDirName(), ts_op);
        cplan.getPathToPartitionInfo().put(fsConf.getDirName(), new partitionDesc(fsConf.getTableInfo(), null));
        cplan.setNumReduceTasks(-1);
        moveWork dummyMv = new moveWork(null, null, null, new loadFileDesc(((fileSinkDesc)fsOp.getConf()).getDirName(), finalName, true, null, null), false);
        Task<moveWork> dummyMergeTask = TaskFactory.get(dummyMv, ctx.getConf(), new Task[0]);
        ArrayList<Serializable> listWorks = new ArrayList<Serializable>();
        listWorks.add(dummyMv);
        listWorks.add(mergeTask.getWork());
        ConditionalWork cndWork = new ConditionalWork(listWorks);
        ConditionalTask cndTsk = (ConditionalTask)TaskFactory.get(cndWork, ctx.getConf(), new Task[0]);
        ArrayList<Task<? extends Serializable>> listTasks = new ArrayList<Task<? extends Serializable>>();
        listTasks.add(dummyMergeTask);
        listTasks.add(mergeTask);
        cndTsk.setListTasks(listTasks);
        cndTsk.setResolver(new ConditionalResolverMergeFiles());
        cndTsk.setResolverCtx(new ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx(listTasks, ((fileSinkDesc)fsOp.getConf()).getDirName()));
        currTask.addDependentTask(cndTsk);
        List<Task<? extends Serializable>> mvTasks = ctx.getMvTask();
        Task<? extends Serializable> mvTask = this.findMoveTask(mvTasks, newOutput);
        if (mvTask != null) {
            cndTsk.addDependentTask(mvTask);
        }
    }

    private Task<? extends Serializable> findMoveTask(List<Task<? extends Serializable>> mvTasks, FileSinkOperator fsOp) {
        for (Task<? extends Serializable> mvTsk : mvTasks) {
            moveWork mvWork = (moveWork)mvTsk.getWork();
            String srcDir = null;
            if (mvWork.getLoadFileWork() != null) {
                srcDir = mvWork.getLoadFileWork().getSourceDir();
            } else if (mvWork.getLoadTableWork() != null) {
                srcDir = mvWork.getLoadTableWork().getSourceDir();
            }
            if (srcDir == null || !srcDir.equalsIgnoreCase(((fileSinkDesc)fsOp.getConf()).getDirName())) continue;
            return mvTsk;
        }
        return null;
    }

    private String processFS(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, boolean chDir) throws SemanticException {
        FileSinkOperator fsOp = (FileSinkOperator)nd;
        if (fsOp.getParentOperators().size() == 1 && fsOp.getParentOperators().get(0) instanceof MapJoinOperator) {
            return null;
        }
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        List<FileSinkOperator> seenFSOps = ctx.getSeenFileSinkOps();
        if (seenFSOps == null) {
            seenFSOps = new ArrayList<FileSinkOperator>();
        }
        if (!seenFSOps.contains(fsOp)) {
            seenFSOps.add(fsOp);
        }
        ctx.setSeenFileSinkOps(seenFSOps);
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        String dest = null;
        if (chDir) {
            dest = ((fileSinkDesc)fsOp.getConf()).getDirName();
            ParseContext parseCtx = ctx.getParseCtx();
            Context baseCtx = parseCtx.getContext();
            String tmpDir = baseCtx.getMRTmpFileURI();
            ((fileSinkDesc)fsOp.getConf()).setDirName(tmpDir);
        }
        boolean ret = false;
        Task<? extends Serializable> mvTask = null;
        if (!chDir) {
            mvTask = this.findMoveTask(ctx.getMvTask(), fsOp);
        }
        Operator<? extends Serializable> currTopOp = ctx.getCurrTopOp();
        String currAliasId = ctx.getCurrAliasId();
        HashMap<Operator<? extends Serializable>, Task<? extends Serializable>> opTaskMap = ctx.getOpTaskMap();
        List<Operator<? extends Serializable>> seenOps = ctx.getSeenOps();
        List<Task<? extends Serializable>> rootTasks = ctx.getRootTasks();
        if (mvTask != null) {
            ret = currTask.addDependentTask(mvTask);
        }
        if (currTopOp != null) {
            Task<? extends Serializable> mapTask = opTaskMap.get(null);
            if (mapTask == null) {
                assert (!seenOps.contains(currTopOp));
                seenOps.add(currTopOp);
                GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, (mapredWork)currTask.getWork(), false, ctx);
                opTaskMap.put(null, currTask);
                rootTasks.add(currTask);
            } else {
                if (!seenOps.contains(currTopOp)) {
                    seenOps.add(currTopOp);
                    GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, (mapredWork)mapTask.getWork(), false, ctx);
                }
                if (ret && mapTask != currTask) {
                    currTask.removeDependentTask(mvTask);
                }
            }
            return dest;
        }
        UnionOperator currUnionOp = ctx.getCurrUnionOp();
        if (currUnionOp != null) {
            opTaskMap.put(null, currTask);
            GenMapRedUtils.initUnionPlan(ctx, currTask, false);
            return dest;
        }
        MapJoinOperator currMapJoinOp = ctx.getCurrMapJoinOp();
        if (currMapJoinOp != null) {
            opTaskMap.put(null, currTask);
            GenMRProcContext.GenMRMapJoinCtx mjCtx = ctx.getMapJoinCtx(currMapJoinOp);
            mapredWork plan = (mapredWork)currTask.getWork();
            String taskTmpDir = mjCtx.getTaskTmpDir();
            tableDesc tt_desc = mjCtx.getTTDesc();
            assert (plan.getPathToAliases().get(taskTmpDir) == null);
            plan.getPathToAliases().put(taskTmpDir, new ArrayList());
            plan.getPathToAliases().get(taskTmpDir).add(taskTmpDir);
            plan.getPathToPartitionInfo().put(taskTmpDir, new partitionDesc(tt_desc, null));
            plan.getAliasToWork().put(taskTmpDir, mjCtx.getRootMapJoinOp());
            return dest;
        }
        return dest;
    }
}

