/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMRRedSink1;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.mapredWork;

public class GenMRRedSink3
implements NodeProcessor {
    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        ReduceSinkOperator op = (ReduceSinkOperator)nd;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        ParseContext parseCtx = ctx.getParseCtx();
        UnionProcContext uCtx = parseCtx.getUCtx();
        if (uCtx.isMapOnlySubq()) {
            return new GenMRRedSink1().process(nd, stack, opProcCtx, nodeOutputs);
        }
        Operator<Serializable> reducer = op.getChildOperators().get(0);
        LinkedHashMap<Operator<? extends Serializable>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
        GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(op.getParentOperators().get(0));
        Task<? extends Serializable> currTask = mapredCtx.getCurrTask();
        mapredWork plan = (mapredWork)currTask.getWork();
        HashMap<Operator<? extends Serializable>, Task<? extends Serializable>> opTaskMap = ctx.getOpTaskMap();
        Task<? extends Serializable> opMapTask = opTaskMap.get(reducer);
        ctx.setCurrTask(currTask);
        if (opMapTask == null) {
            if (plan.getReducer() == null) {
                GenMapRedUtils.initUnionPlan(op, ctx);
            } else {
                GenMapRedUtils.splitPlan(op, ctx);
            }
        } else if (plan.getReducer() == reducer) {
            GenMapRedUtils.initUnionPlan(op, ctx);
        } else {
            GenMapRedUtils.initUnionPlan(ctx, currTask, false);
            GenMapRedUtils.joinPlan(op, currTask, opMapTask, ctx, -1, true, false, false);
        }
        mapCurrCtx.put(op, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), ctx.getCurrTopOp(), ctx.getCurrAliasId()));
        ctx.setCurrUnionOp(null);
        return null;
    }
}

