/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.ppr;

import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.ppr.ExprProcFactory;
import org.apache.hadoop.hive.ql.optimizer.ppr.OpWalkerCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.ql.plan.filterDesc;
import org.apache.hadoop.hive.ql.plan.tableScanDesc;

public class OpProcFactory {
    public static NodeProcessor getFilterProc() {
        return new FilterPPR();
    }

    public static NodeProcessor getDefaultProc() {
        return new DefaultPPR();
    }

    public static class DefaultPPR
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    public static class FilterPPR
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            OpWalkerCtx owc = (OpWalkerCtx)procCtx;
            FilterOperator fop = (FilterOperator)nd;
            FilterOperator fop2 = null;
            Node tmp = stack.pop();
            Node tmp2 = stack.pop();
            TableScanOperator top = null;
            if (tmp2 instanceof TableScanOperator) {
                top = (TableScanOperator)tmp2;
            } else {
                top = (TableScanOperator)stack.peek();
                fop2 = (FilterOperator)tmp2;
            }
            stack.push(tmp2);
            stack.push(tmp);
            if (fop2 != null && !((filterDesc)fop2.getConf()).getIsSamplingPred()) {
                return null;
            }
            if (((filterDesc)fop.getConf()).getIsSamplingPred()) {
                return null;
            }
            exprNodeDesc predicate = ((filterDesc)fop.getConf()).getPredicate();
            String alias = ((tableScanDesc)top.getConf()).getAlias();
            boolean hasNonPartCols = false;
            exprNodeDesc ppr_pred = ExprProcFactory.genPruner(alias, predicate, hasNonPartCols);
            owc.addHasNonPartCols(hasNonPartCols);
            this.addPruningPred(owc.getOpToPartPruner(), top, ppr_pred);
            return null;
        }

        private void addPruningPred(Map<TableScanOperator, exprNodeDesc> opToPPR, TableScanOperator top, exprNodeDesc new_ppr_pred) {
            exprNodeDesc old_ppr_pred = opToPPR.get(top);
            exprNodeDesc ppr_pred = null;
            ppr_pred = old_ppr_pred != null ? TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDesc("OR", old_ppr_pred, new_ppr_pred) : new_ppr_pred;
            opToPPR.put(top, ppr_pred);
        }
    }
}

