/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.unionproc;

import java.io.Serializable;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.unionDesc;

public class UnionProcFactory {
    public static int getPositionParent(UnionOperator union, Stack<Node> stack) {
        int pos = 0;
        int size = stack.size();
        assert (size >= 2 && stack.get(size - 1) == union);
        Operator parent = (Operator)stack.get(size - 2);
        List<Operator<Serializable>> parUnion = union.getParentOperators();
        pos = parUnion.indexOf(parent);
        assert (pos < parUnion.size());
        return pos;
    }

    public static NodeProcessor getMapRedUnion() {
        return new MapRedUnion();
    }

    public static NodeProcessor getMapUnion() {
        return new MapUnion();
    }

    public static NodeProcessor getMapJoinUnion() {
        return new MapJoinUnion();
    }

    public static NodeProcessor getUnknownUnion() {
        return new UnknownUnion();
    }

    public static NodeProcessor getNoUnion() {
        return new NoUnion();
    }

    public static class NoUnion
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    public static class UnknownUnion
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            UnionOperator union = (UnionOperator)nd;
            UnionProcContext ctx = (UnionProcContext)procCtx;
            int pos = UnionProcFactory.getPositionParent(union, stack);
            UnionProcContext.UnionParseContext uCtx = ctx.getUnionParseContext(union);
            if (uCtx == null) {
                uCtx = new UnionProcContext.UnionParseContext(((unionDesc)union.getConf()).getNumInputs());
            }
            uCtx.setMapOnlySubq(pos, true);
            uCtx.setRootTask(pos, false);
            ctx.setUnionParseContext(union, uCtx);
            return null;
        }
    }

    public static class MapJoinUnion
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            UnionOperator union = (UnionOperator)nd;
            UnionProcContext ctx = (UnionProcContext)procCtx;
            int pos = UnionProcFactory.getPositionParent(union, stack);
            UnionProcContext.UnionParseContext uCtx = ctx.getUnionParseContext(union);
            if (uCtx == null) {
                uCtx = new UnionProcContext.UnionParseContext(((unionDesc)union.getConf()).getNumInputs());
            }
            uCtx.setMapJoinSubq(pos, true);
            ctx.setUnionParseContext(union, uCtx);
            return null;
        }
    }

    public static class MapUnion
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            UnionOperator union = (UnionOperator)nd;
            UnionProcContext ctx = (UnionProcContext)procCtx;
            int pos = UnionProcFactory.getPositionParent(union, stack);
            UnionProcContext.UnionParseContext uCtx = ctx.getUnionParseContext(union);
            if (uCtx == null) {
                uCtx = new UnionProcContext.UnionParseContext(((unionDesc)union.getConf()).getNumInputs());
            }
            uCtx.setMapOnlySubq(pos, true);
            uCtx.setRootTask(pos, true);
            ctx.setUnionParseContext(union, uCtx);
            return null;
        }
    }

    public static class MapRedUnion
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            UnionOperator union = (UnionOperator)nd;
            UnionProcContext ctx = (UnionProcContext)procCtx;
            int pos = UnionProcFactory.getPositionParent(union, stack);
            UnionProcContext.UnionParseContext uCtx = ctx.getUnionParseContext(union);
            if (uCtx == null) {
                uCtx = new UnionProcContext.UnionParseContext(((unionDesc)union.getConf()).getNumInputs());
            }
            ctx.setMapOnlySubq(false);
            uCtx.setMapOnlySubq(pos, false);
            uCtx.setRootTask(pos, false);
            ctx.setUnionParseContext(union, uCtx);
            return null;
        }
    }
}

