/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class RowResolver {
    private RowSchema rowSchema = new RowSchema();
    private HashMap<String, LinkedHashMap<String, ColumnInfo>> rslvMap = new HashMap();
    private HashMap<String, String[]> invRslvMap = new HashMap();
    private boolean isExprResolver = false;
    private static final Log LOG = LogFactory.getLog((String)RowResolver.class.getName());

    public void put(String tab_alias, String col_alias, ColumnInfo colInfo) {
        if (tab_alias != null) {
            tab_alias = tab_alias.toLowerCase();
        }
        col_alias = col_alias.toLowerCase();
        if (this.rowSchema.getSignature() == null) {
            this.rowSchema.setSignature(new Vector<ColumnInfo>());
        }
        this.rowSchema.getSignature().add(colInfo);
        LinkedHashMap<String, ColumnInfo> f_map = this.rslvMap.get(tab_alias);
        if (f_map == null) {
            f_map = new LinkedHashMap();
            this.rslvMap.put(tab_alias, f_map);
        }
        f_map.put(col_alias, colInfo);
        String[] qualifiedAlias = new String[]{tab_alias, col_alias};
        this.invRslvMap.put(colInfo.getInternalName(), qualifiedAlias);
    }

    public boolean hasTableAlias(String tab_alias) {
        return this.rslvMap.get(tab_alias.toLowerCase()) != null;
    }

    public ColumnInfo get(String tab_alias, String col_alias) throws SemanticException {
        col_alias = col_alias.toLowerCase();
        ColumnInfo ret = null;
        if (tab_alias != null) {
            HashMap f_map = this.rslvMap.get(tab_alias = tab_alias.toLowerCase());
            if (f_map == null) {
                return null;
            }
            ret = (ColumnInfo)f_map.get(col_alias);
        } else {
            boolean found = false;
            for (LinkedHashMap<String, ColumnInfo> cmap : this.rslvMap.values()) {
                for (Map.Entry<String, ColumnInfo> cmapEnt : cmap.entrySet()) {
                    if (!col_alias.equalsIgnoreCase(cmapEnt.getKey())) continue;
                    if (found) {
                        throw new SemanticException("Column " + col_alias + " Found in more than One Tables/Subqueries");
                    }
                    found = true;
                    ret = cmapEnt.getValue();
                }
            }
        }
        return ret;
    }

    public Vector<ColumnInfo> getColumnInfos() {
        return this.rowSchema.getSignature();
    }

    public HashMap<String, ColumnInfo> getFieldMap(String tab_alias) {
        if (tab_alias == null) {
            return this.rslvMap.get(null);
        }
        return this.rslvMap.get(tab_alias.toLowerCase());
    }

    public int getPosition(String internalName) {
        int pos = -1;
        for (ColumnInfo var : this.rowSchema.getSignature()) {
            ++pos;
            if (!var.getInternalName().equals(internalName)) continue;
            return pos;
        }
        return -1;
    }

    public Set<String> getTableNames() {
        return this.rslvMap.keySet();
    }

    public String[] reverseLookup(String internalName) {
        return this.invRslvMap.get(internalName);
    }

    public void setIsExprResolver(boolean isExprResolver) {
        this.isExprResolver = isExprResolver;
    }

    public boolean getIsExprResolver() {
        return this.isExprResolver;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, LinkedHashMap<String, ColumnInfo>> e : this.rslvMap.entrySet()) {
            String tab = e.getKey();
            sb.append(tab + "{");
            HashMap f_map = e.getValue();
            if (f_map != null) {
                for (Map.Entry entry : f_map.entrySet()) {
                    sb.append("(" + (String)entry.getKey() + "," + ((ColumnInfo)entry.getValue()).toString() + ")");
                }
            }
            sb.append("} ");
        }
        return sb.toString();
    }
}

