/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class SemanticAnalyzerFactory {
    static HashMap<Integer, String> commandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType.get(tree.getToken().getType()));
        }
        switch (tree.getToken().getType()) {
            case 125: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 61: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 114: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 123: 
            case 124: {
                return new FunctionSemanticAnalyzer(conf);
            }
        }
        return new SemanticAnalyzer(conf);
    }

    static {
        commandType.put(125, "EXPLAIN");
        commandType.put(61, "LOAD");
        commandType.put(79, "CREATETABLE");
        commandType.put(99, "DROPTABLE");
        commandType.put(81, "DESCTABLE");
        commandType.put(82, "DESCFUNCTION");
        commandType.put(94, "MSCK");
        commandType.put(84, "ALTERTABLE_ADDCOLS");
        commandType.put(86, "ALTERTABLE_REPLACECOLS");
        commandType.put(85, "ALTERTABLE_RENAMECOL");
        commandType.put(83, "ALTERTABLE_RENAME");
        commandType.put(88, "ALTERTABLE_DROPPARTS");
        commandType.put(87, "ALTERTABLE_ADDPARTS");
        commandType.put(92, "ALTERTABLE_PROPERTIES");
        commandType.put(90, "ALTERTABLE_SERIALIZER");
        commandType.put(89, "ALTERTABLE_SERDEPROPERTIES");
        commandType.put(95, "SHOWTABLES");
        commandType.put(98, "SHOW_TABLESTATUS");
        commandType.put(96, "SHOWFUNCTIONS");
        commandType.put(97, "SHOWPARTITIONS");
        commandType.put(123, "CREATEFUNCTION");
        commandType.put(124, "DROPFUNCTION");
        commandType.put(5, "QUERY");
    }
}

