/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ddlDesc;
import org.apache.hadoop.hive.ql.plan.explain;

@explain(displayName="Create Table")
public class createTableDesc
extends ddlDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    String tableName;
    boolean isExternal;
    List<FieldSchema> cols;
    List<FieldSchema> partCols;
    List<String> bucketCols;
    List<Order> sortCols;
    int numBuckets;
    String fieldDelim;
    String fieldEscape;
    String collItemDelim;
    String mapKeyDelim;
    String lineDelim;
    String comment;
    String inputFormat;
    String outputFormat;
    String location;
    String serName;
    Map<String, String> mapProp;
    boolean ifNotExists;

    public createTableDesc(String tableName, boolean isExternal, List<FieldSchema> cols, List<FieldSchema> partCols, List<String> bucketCols, List<Order> sortCols, int numBuckets, String fieldDelim, String fieldEscape, String collItemDelim, String mapKeyDelim, String lineDelim, String comment, String inputFormat, String outputFormat, String location, String serName, Map<String, String> mapProp, boolean ifNotExists) {
        this.tableName = tableName;
        this.isExternal = isExternal;
        this.bucketCols = bucketCols;
        this.sortCols = sortCols;
        this.collItemDelim = collItemDelim;
        this.cols = cols;
        this.comment = comment;
        this.fieldDelim = fieldDelim;
        this.fieldEscape = fieldEscape;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.lineDelim = lineDelim;
        this.location = location;
        this.mapKeyDelim = mapKeyDelim;
        this.numBuckets = numBuckets;
        this.partCols = partCols;
        this.serName = serName;
        this.mapProp = mapProp;
        this.ifNotExists = ifNotExists;
    }

    @explain(displayName="if not exists")
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @explain(displayName="name")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<FieldSchema> getCols() {
        return this.cols;
    }

    @explain(displayName="columns")
    public List<String> getColsString() {
        return Utilities.getFieldSchemaString(this.getCols());
    }

    public void setCols(List<FieldSchema> cols) {
        this.cols = cols;
    }

    public List<FieldSchema> getPartCols() {
        return this.partCols;
    }

    @explain(displayName="partition columns")
    public List<String> getPartColsString() {
        return Utilities.getFieldSchemaString(this.getPartCols());
    }

    public void setPartCols(List<FieldSchema> partCols) {
        this.partCols = partCols;
    }

    @explain(displayName="bucket columns")
    public List<String> getBucketCols() {
        return this.bucketCols;
    }

    public void setBucketCols(List<String> bucketCols) {
        this.bucketCols = bucketCols;
    }

    @explain(displayName="# buckets")
    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
    }

    @explain(displayName="field delimiter")
    public String getFieldDelim() {
        return this.fieldDelim;
    }

    public void setFieldDelim(String fieldDelim) {
        this.fieldDelim = fieldDelim;
    }

    @explain(displayName="field escape")
    public String getFieldEscape() {
        return this.fieldEscape;
    }

    public void setFieldEscape(String fieldEscape) {
        this.fieldEscape = fieldEscape;
    }

    @explain(displayName="collection delimiter")
    public String getCollItemDelim() {
        return this.collItemDelim;
    }

    public void setCollItemDelim(String collItemDelim) {
        this.collItemDelim = collItemDelim;
    }

    @explain(displayName="map key delimiter")
    public String getMapKeyDelim() {
        return this.mapKeyDelim;
    }

    public void setMapKeyDelim(String mapKeyDelim) {
        this.mapKeyDelim = mapKeyDelim;
    }

    @explain(displayName="line delimiter")
    public String getLineDelim() {
        return this.lineDelim;
    }

    public void setLineDelim(String lineDelim) {
        this.lineDelim = lineDelim;
    }

    @explain(displayName="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @explain(displayName="input format")
    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    @explain(displayName="output format")
    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @explain(displayName="location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @explain(displayName="isExternal")
    public boolean isExternal() {
        return this.isExternal;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    @explain(displayName="sort columns")
    public List<Order> getSortCols() {
        return this.sortCols;
    }

    public void setSortCols(List<Order> sortCols) {
        this.sortCols = sortCols;
    }

    @explain(displayName="serde name")
    public String getSerName() {
        return this.serName;
    }

    public void setSerName(String serName) {
        this.serName = serName;
    }

    @explain(displayName="serde properties")
    public Map<String, String> getMapProp() {
        return this.mapProp;
    }

    public void setMapProp(Map<String, String> mapProp) {
        this.mapProp = mapProp;
    }
}

