/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.plan.explain;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class exprNodeColumnDesc
extends exprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String column;
    private String tabAlias;
    private boolean isPartitionCol;

    public exprNodeColumnDesc() {
    }

    public exprNodeColumnDesc(TypeInfo typeInfo, String column, String tabAlias, boolean isPartitionCol) {
        super(typeInfo);
        this.column = column;
        this.tabAlias = tabAlias;
        this.isPartitionCol = isPartitionCol;
    }

    public exprNodeColumnDesc(Class<?> c, String column, String tabAlias, boolean isPartitionCol) {
        super(TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(c));
        this.column = column;
        this.tabAlias = tabAlias;
        this.isPartitionCol = isPartitionCol;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getTabAlias() {
        return this.tabAlias;
    }

    public void setTabAlias(String tabAlias) {
        this.tabAlias = tabAlias;
    }

    public boolean getIsParititonCol() {
        return this.isPartitionCol;
    }

    public void setIsPartitionCol(boolean isPartitionCol) {
        this.isPartitionCol = isPartitionCol;
    }

    public String toString() {
        return "Column[" + this.column + "]";
    }

    @Override
    @explain(displayName="expr")
    public String getExprString() {
        return this.getColumn();
    }

    @Override
    public List<String> getCols() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add(this.column);
        return lst;
    }

    @Override
    public exprNodeDesc clone() {
        return new exprNodeColumnDesc(this.typeInfo, this.column, this.tabAlias, this.isPartitionCol);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof exprNodeColumnDesc)) {
            return false;
        }
        exprNodeColumnDesc dest = (exprNodeColumnDesc)o;
        if (!this.column.equals(dest.getColumn())) {
            return false;
        }
        return this.typeInfo.equals(dest.getTypeInfo());
    }
}

