/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.hadoop.hive.ql.plan.aggregationDesc;
import org.apache.hadoop.hive.ql.plan.explain;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;

@explain(displayName="Group By Operator")
public class groupByDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Mode mode;
    private boolean groupKeyNotReductionKey;
    private boolean bucketGroup;
    private ArrayList<exprNodeDesc> keys;
    private ArrayList<aggregationDesc> aggregators;
    private ArrayList<String> outputColumnNames;

    public groupByDesc() {
    }

    public groupByDesc(Mode mode, ArrayList<String> outputColumnNames, ArrayList<exprNodeDesc> keys, ArrayList<aggregationDesc> aggregators, boolean groupKeyNotReductionKey) {
        this(mode, outputColumnNames, keys, aggregators, groupKeyNotReductionKey, false);
    }

    public groupByDesc(Mode mode, ArrayList<String> outputColumnNames, ArrayList<exprNodeDesc> keys, ArrayList<aggregationDesc> aggregators, boolean groupKeyNotReductionKey, boolean bucketGroup) {
        this.mode = mode;
        this.outputColumnNames = outputColumnNames;
        this.keys = keys;
        this.aggregators = aggregators;
        this.groupKeyNotReductionKey = groupKeyNotReductionKey;
        this.bucketGroup = bucketGroup;
    }

    public Mode getMode() {
        return this.mode;
    }

    @explain(displayName="mode")
    public String getModeString() {
        switch (this.mode) {
            case COMPLETE: {
                return "complete";
            }
            case PARTIAL1: {
                return "partial1";
            }
            case PARTIAL2: {
                return "partial2";
            }
            case PARTIALS: {
                return "partials";
            }
            case HASH: {
                return "hash";
            }
            case FINAL: {
                return "final";
            }
            case MERGEPARTIAL: {
                return "mergepartial";
            }
        }
        return "unknown";
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @explain(displayName="keys")
    public ArrayList<exprNodeDesc> getKeys() {
        return this.keys;
    }

    public void setKeys(ArrayList<exprNodeDesc> keys) {
        this.keys = keys;
    }

    @explain(displayName="outputColumnNames")
    public ArrayList<String> getOutputColumnNames() {
        return this.outputColumnNames;
    }

    public void setOutputColumnNames(ArrayList<String> outputColumnNames) {
        this.outputColumnNames = outputColumnNames;
    }

    @explain(displayName="aggregations")
    public ArrayList<aggregationDesc> getAggregators() {
        return this.aggregators;
    }

    public void setAggregators(ArrayList<aggregationDesc> aggregators) {
        this.aggregators = aggregators;
    }

    public boolean getGroupKeyNotReductionKey() {
        return this.groupKeyNotReductionKey;
    }

    public void setGroupKeyNotReductionKey(boolean groupKeyNotReductionKey) {
        this.groupKeyNotReductionKey = groupKeyNotReductionKey;
    }

    @explain(displayName="bucketGroup")
    public boolean getBucketGroup() {
        return this.bucketGroup;
    }

    public void setBucketGroup(boolean dataSorted) {
        this.bucketGroup = dataSorted;
    }

    public static enum Mode {
        COMPLETE,
        PARTIAL1,
        PARTIAL2,
        PARTIALS,
        FINAL,
        HASH,
        MERGEPARTIAL;

    }
}

