/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.io.Text;

@description(name="to_date", value="_FUNC_(expr) - Extracts the date part of the date or datetime expression expr", extended="Example:\n   > SELECT _FUNC_('2009-30-07 04:17:52') FROM src LIMIT 1;\n  '2009-30-07'")
public class UDFDate
extends UDF {
    private static Log LOG = LogFactory.getLog((String)UDFDate.class.getName());
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    Text t = new Text();

    public Text evaluate(Text dateString) {
        if (dateString == null) {
            return null;
        }
        try {
            Date date = this.formatter.parse(dateString.toString());
            this.t.set(this.formatter.format(date));
            return this.t;
        }
        catch (ParseException e) {
            return null;
        }
    }
}

