/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@description(name="log", value="_FUNC_([b], x) - Returns the logarithm of x with base b", extended="Example:\n  > SELECT _FUNC_(13, 13) FROM src LIMIT 1;\n  1")
public class UDFLog
extends UDF {
    private static Log LOG = LogFactory.getLog((String)UDFLog.class.getName());
    DoubleWritable result = new DoubleWritable();

    public DoubleWritable evaluate(DoubleWritable a) {
        if (a == null || a.get() <= 0.0) {
            return null;
        }
        this.result.set(Math.log(a.get()));
        return this.result;
    }

    public DoubleWritable evaluate(DoubleWritable base, DoubleWritable a) {
        if (a == null || a.get() <= 0.0 || base == null || base.get() <= 1.0) {
            return null;
        }
        this.result.set(Math.log(a.get()) / Math.log(base.get()));
        return this.result;
    }
}

