/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@description(name="lpad", value="_FUNC_(str, len, pad) - Returns str, left-padded with pad to a length of len", extended="If str is longer than len, the return value is shortened to len characters.\nExample:\n  > SELECT _FUNC_('hi', 5, '??') FROM src LIMIT 1;\n  '???hi'  > SELECT _FUNC_('hi', 1, '??') FROM src LIMIT 1;\n  'h'")
public class UDFLpad
extends UDF {
    private Text result = new Text();

    public Text evaluate(Text s, IntWritable n, Text pad) {
        int i;
        if (s == null || n == null || pad == null) {
            return null;
        }
        int len = n.get();
        byte[] data = this.result.getBytes();
        if (data.length < len) {
            data = new byte[len];
        }
        byte[] txt = s.getBytes();
        byte[] padTxt = pad.getBytes();
        int pos = Math.max(len - s.getLength(), 0);
        for (i = 0; i < pos; i += pad.getLength()) {
            for (int j = 0; j < pad.getLength() && j < pos - i; ++j) {
                data[i + j] = padTxt[j];
            }
        }
        for (i = 0; pos + i < len && i < s.getLength(); ++i) {
            data[pos + i] = txt[i];
        }
        this.result.set(data, 0, len);
        return this.result;
    }
}

