/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.dynamic_type.DynamicSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.thrift.ThriftDeserializer;

public class SerDeUtils {
    public static final char QUOTE = '\"';
    public static final char COLON = ':';
    public static final char COMMA = ',';
    public static final String LBRACKET = "[";
    public static final String RBRACKET = "]";
    public static final String LBRACE = "{";
    public static final String RBRACE = "}";
    private static HashMap<String, Class<?>> serdes = new HashMap();
    private static List<String> nativeSerDeNames = new ArrayList<String>();
    private static boolean initCoreSerDes;

    public static void registerSerDe(String name, Class<?> serde) {
        if (serdes.containsKey(name)) {
            throw new RuntimeException("double registering serde " + name);
        }
        serdes.put(name, serde);
    }

    public static Deserializer lookupDeserializer(String name) throws SerDeException {
        Class<?> c;
        if (serdes.containsKey(name)) {
            c = serdes.get(name);
        } else {
            try {
                c = Class.forName(name, true, JavaUtils.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new SerDeException("SerDe " + name + " does not exist");
            }
        }
        try {
            return (Deserializer)c.newInstance();
        }
        catch (Exception e) {
            throw new SerDeException(e);
        }
    }

    public static boolean isNativeSerDe(String serde) {
        return nativeSerDeNames.contains(serde);
    }

    protected static boolean registerCoreSerDes() {
        try {
            Class.forName(MetadataTypedColumnsetSerDe.class.getName());
            Class.forName(LazySimpleSerDe.class.getName());
            Class.forName(ThriftDeserializer.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("IMPOSSIBLE Exception: Unable to initialize core serdes", e);
        }
        return true;
    }

    public static String escapeString(String str) {
        int length = str.length();
        StringBuilder escape = new StringBuilder(length + 16);
        block8: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    escape.append('\\');
                    escape.append(c);
                    continue block8;
                }
                case '\b': {
                    escape.append('\\');
                    escape.append('b');
                    continue block8;
                }
                case '\f': {
                    escape.append('\\');
                    escape.append('f');
                    continue block8;
                }
                case '\n': {
                    escape.append('\\');
                    escape.append('n');
                    continue block8;
                }
                case '\r': {
                    escape.append('\\');
                    escape.append('r');
                    continue block8;
                }
                case '\t': {
                    escape.append('\\');
                    escape.append('t');
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String hex = Integer.toHexString(c);
                        escape.append('\\');
                        escape.append('u');
                        for (int j = 4; j > hex.length(); --j) {
                            escape.append('0');
                        }
                        escape.append(hex);
                        continue block8;
                    }
                    escape.append(c);
                }
            }
        }
        return escape.toString();
    }

    public static String lightEscapeString(String str) {
        int length = str.length();
        StringBuilder escape = new StringBuilder(length + 16);
        block5: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    escape.append('\\');
                    escape.append('n');
                    continue block5;
                }
                case '\r': {
                    escape.append('\\');
                    escape.append('r');
                    continue block5;
                }
                case '\t': {
                    escape.append('\\');
                    escape.append('t');
                    continue block5;
                }
                default: {
                    escape.append(c);
                }
            }
        }
        return escape.toString();
    }

    public static String getJSONString(Object o, ObjectInspector oi) {
        StringBuilder sb = new StringBuilder();
        SerDeUtils.buildJSONString(sb, o, oi);
        return sb.toString();
    }

    static void buildJSONString(StringBuilder sb, Object o, ObjectInspector oi) {
        block0 : switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                if (o == null) {
                    sb.append("null");
                    break;
                }
                switch (poi.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        boolean b = ((BooleanObjectInspector)poi).get(o);
                        sb.append(b ? "true" : "false");
                        break block0;
                    }
                    case BYTE: {
                        sb.append(((ByteObjectInspector)poi).get(o));
                        break block0;
                    }
                    case SHORT: {
                        sb.append(((ShortObjectInspector)poi).get(o));
                        break block0;
                    }
                    case INT: {
                        sb.append(((IntObjectInspector)poi).get(o));
                        break block0;
                    }
                    case LONG: {
                        sb.append(((LongObjectInspector)poi).get(o));
                        break block0;
                    }
                    case FLOAT: {
                        sb.append(((FloatObjectInspector)poi).get(o));
                        break block0;
                    }
                    case DOUBLE: {
                        sb.append(((DoubleObjectInspector)poi).get(o));
                        break block0;
                    }
                    case STRING: {
                        sb.append('\"');
                        sb.append(SerDeUtils.escapeString(((StringObjectInspector)poi).getPrimitiveJavaObject(o)));
                        sb.append('\"');
                        break block0;
                    }
                }
                throw new RuntimeException("Unknown primitive type: " + (Object)((Object)poi.getPrimitiveCategory()));
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                ObjectInspector listElementObjectInspector = loi.getListElementObjectInspector();
                List<?> olist = loi.getList(o);
                if (olist == null) {
                    sb.append("null");
                    break;
                }
                sb.append(LBRACKET);
                for (int i = 0; i < olist.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    SerDeUtils.buildJSONString(sb, olist.get(i), listElementObjectInspector);
                }
                sb.append(RBRACKET);
                break;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                ObjectInspector mapKeyObjectInspector = moi.getMapKeyObjectInspector();
                ObjectInspector mapValueObjectInspector = moi.getMapValueObjectInspector();
                Map<?, ?> omap = moi.getMap(o);
                if (omap == null) {
                    sb.append("null");
                    break;
                }
                sb.append(LBRACE);
                boolean first = true;
                for (Map.Entry<?, ?> entry : omap.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    Map.Entry<?, ?> e = entry;
                    SerDeUtils.buildJSONString(sb, e.getKey(), mapKeyObjectInspector);
                    sb.append(':');
                    SerDeUtils.buildJSONString(sb, e.getValue(), mapValueObjectInspector);
                }
                sb.append(RBRACE);
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                List<? extends StructField> structFields = soi.getAllStructFieldRefs();
                if (o == null) {
                    sb.append("null");
                    break;
                }
                sb.append(LBRACE);
                for (int i = 0; i < structFields.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append('\"');
                    sb.append(structFields.get(i).getFieldName());
                    sb.append('\"');
                    sb.append(':');
                    SerDeUtils.buildJSONString(sb, soi.getStructFieldData(o, structFields.get(i)), structFields.get(i).getFieldObjectInspector());
                }
                sb.append(RBRACE);
                break;
            }
            default: {
                throw new RuntimeException("Unknown type in ObjectInspector!");
            }
        }
    }

    static {
        nativeSerDeNames.add(DynamicSerDe.class.getName());
        nativeSerDeNames.add(MetadataTypedColumnsetSerDe.class.getName());
        nativeSerDeNames.add("org.apache.hadoop.hive.serde.thrift.columnsetSerDe");
        nativeSerDeNames.add(LazySimpleSerDe.class.getName());
        initCoreSerDes = SerDeUtils.registerCoreSerDes();
    }
}

