/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.nio.charset.CharacterCodingException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDoubleObjectInspector;
import org.apache.hadoop.io.Text;

public class LazyDouble
extends LazyPrimitive<LazyDoubleObjectInspector, DoubleWritable> {
    public LazyDouble(LazyDoubleObjectInspector oi) {
        super(oi);
        this.data = new DoubleWritable();
    }

    public LazyDouble(LazyDouble copy) {
        super(copy);
        this.data = new DoubleWritable(((DoubleWritable)copy.data).get());
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        try {
            ((DoubleWritable)this.data).set(Double.parseDouble(Text.decode((byte[])bytes.getData(), (int)start, (int)length)));
            this.isNull = false;
        }
        catch (NumberFormatException e) {
            this.isNull = true;
        }
        catch (CharacterCodingException e) {
            this.isNull = true;
        }
    }
}

