/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.util.typedbytes;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.hive.contrib.util.typedbytes.Type;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.record.Buffer;

public class TypedBytesInput {
    private DataInput in;
    private static ThreadLocal tbIn = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new TypedBytesInput();
        }
    };

    private TypedBytesInput() {
    }

    private void setDataInput(DataInput in) {
        this.in = in;
    }

    public static TypedBytesInput get(DataInput in) {
        TypedBytesInput bin = (TypedBytesInput)tbIn.get();
        bin.setDataInput(in);
        return bin;
    }

    public TypedBytesInput(DataInput in) {
        this.in = in;
    }

    public Object read() throws IOException {
        int code = 1;
        try {
            code = this.in.readUnsignedByte();
        }
        catch (EOFException eof) {
            return null;
        }
        if (code == Type.BYTES.code) {
            return new Buffer(this.readBytes());
        }
        if (code == Type.BYTE.code) {
            return this.readByte();
        }
        if (code == Type.BOOL.code) {
            return this.readBool();
        }
        if (code == Type.INT.code) {
            return this.readInt();
        }
        if (code == Type.SHORT.code) {
            return this.readShort();
        }
        if (code == Type.LONG.code) {
            return this.readLong();
        }
        if (code == Type.FLOAT.code) {
            return Float.valueOf(this.readFloat());
        }
        if (code == Type.DOUBLE.code) {
            return this.readDouble();
        }
        if (code == Type.STRING.code) {
            return this.readString();
        }
        if (code == Type.VECTOR.code) {
            return this.readVector();
        }
        if (code == Type.LIST.code) {
            return this.readList();
        }
        if (code == Type.MAP.code) {
            return this.readMap();
        }
        if (code == Type.MARKER.code) {
            return null;
        }
        if (50 <= code && code <= 200) {
            return new Buffer(this.readBytes());
        }
        throw new RuntimeException("unknown type");
    }

    public byte[] readRaw() throws IOException {
        int code = -1;
        try {
            code = this.in.readUnsignedByte();
        }
        catch (EOFException eof) {
            return null;
        }
        if (code == Type.BYTES.code) {
            return this.readRawBytes();
        }
        if (code == Type.BYTE.code) {
            return this.readRawByte();
        }
        if (code == Type.BOOL.code) {
            return this.readRawBool();
        }
        if (code == Type.INT.code) {
            return this.readRawInt();
        }
        if (code == Type.LONG.code) {
            return this.readRawLong();
        }
        if (code == Type.FLOAT.code) {
            return this.readRawFloat();
        }
        if (code == Type.DOUBLE.code) {
            return this.readRawDouble();
        }
        if (code == Type.STRING.code) {
            return this.readRawString();
        }
        if (code == Type.VECTOR.code) {
            return this.readRawVector();
        }
        if (code == Type.LIST.code) {
            return this.readRawList();
        }
        if (code == Type.MAP.code) {
            return this.readRawMap();
        }
        if (code == Type.MARKER.code) {
            return null;
        }
        if (50 <= code && code <= 200) {
            return this.readRawBytes();
        }
        throw new RuntimeException("unknown type");
    }

    public Type readType() throws IOException {
        int code = -1;
        try {
            code = this.in.readUnsignedByte();
        }
        catch (EOFException eof) {
            return null;
        }
        for (Type type : Type.values()) {
            if (type.code != code) continue;
            return type;
        }
        return null;
    }

    public boolean skipType() throws IOException {
        try {
            this.in.readByte();
            return true;
        }
        catch (EOFException eof) {
            return false;
        }
    }

    public byte[] readBytes() throws IOException {
        int length = this.in.readInt();
        byte[] bytes = new byte[length];
        this.in.readFully(bytes);
        return bytes;
    }

    public byte[] readRawBytes() throws IOException {
        int length = this.in.readInt();
        byte[] bytes = new byte[5 + length];
        bytes[0] = (byte)Type.BYTES.code;
        bytes[1] = (byte)(0xFF & length >> 24);
        bytes[2] = (byte)(0xFF & length >> 16);
        bytes[3] = (byte)(0xFF & length >> 8);
        bytes[4] = (byte)(0xFF & length);
        this.in.readFully(bytes, 5, length);
        return bytes;
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public byte[] readRawByte() throws IOException {
        byte[] bytes = new byte[2];
        bytes[0] = (byte)Type.BYTE.code;
        this.in.readFully(bytes, 1, 1);
        return bytes;
    }

    public boolean readBool() throws IOException {
        return this.in.readBoolean();
    }

    public byte[] readRawBool() throws IOException {
        byte[] bytes = new byte[2];
        bytes[0] = (byte)Type.BOOL.code;
        this.in.readFully(bytes, 1, 1);
        return bytes;
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public short readShort() throws IOException {
        return this.in.readShort();
    }

    public byte[] readRawInt() throws IOException {
        byte[] bytes = new byte[5];
        bytes[0] = (byte)Type.INT.code;
        this.in.readFully(bytes, 1, 4);
        return bytes;
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public byte[] readRawLong() throws IOException {
        byte[] bytes = new byte[9];
        bytes[0] = (byte)Type.LONG.code;
        this.in.readFully(bytes, 1, 8);
        return bytes;
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public byte[] readRawFloat() throws IOException {
        byte[] bytes = new byte[5];
        bytes[0] = (byte)Type.FLOAT.code;
        this.in.readFully(bytes, 1, 4);
        return bytes;
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public byte[] readRawDouble() throws IOException {
        byte[] bytes = new byte[9];
        bytes[0] = (byte)Type.DOUBLE.code;
        this.in.readFully(bytes, 1, 8);
        return bytes;
    }

    public String readString() throws IOException {
        return WritableUtils.readString((DataInput)this.in);
    }

    public byte[] readRawString() throws IOException {
        int length = this.in.readInt();
        byte[] bytes = new byte[5 + length];
        bytes[0] = (byte)Type.STRING.code;
        bytes[1] = (byte)(0xFF & length >> 24);
        bytes[2] = (byte)(0xFF & length >> 16);
        bytes[3] = (byte)(0xFF & length >> 8);
        bytes[4] = (byte)(0xFF & length);
        this.in.readFully(bytes, 5, length);
        return bytes;
    }

    public ArrayList readVector() throws IOException {
        int length = this.readVectorHeader();
        ArrayList<Object> result = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            result.add(this.read());
        }
        return result;
    }

    public byte[] readRawVector() throws IOException {
        Buffer buffer = new Buffer();
        int length = this.readVectorHeader();
        buffer.append(new byte[]{(byte)Type.VECTOR.code, (byte)(0xFF & length >> 24), (byte)(0xFF & length >> 16), (byte)(0xFF & length >> 8), (byte)(0xFF & length)});
        for (int i = 0; i < length; ++i) {
            buffer.append(this.readRaw());
        }
        return buffer.get();
    }

    public int readVectorHeader() throws IOException {
        return this.in.readInt();
    }

    public List readList() throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        Object obj = this.read();
        while (obj != null) {
            list.add(obj);
            obj = this.read();
        }
        return list;
    }

    public byte[] readRawList() throws IOException {
        Buffer buffer = new Buffer(new byte[]{(byte)Type.LIST.code});
        byte[] bytes = this.readRaw();
        while (bytes != null) {
            buffer.append(bytes);
            bytes = this.readRaw();
        }
        buffer.append(new byte[]{(byte)Type.MARKER.code});
        return buffer.get();
    }

    public TreeMap readMap() throws IOException {
        int length = this.readMapHeader();
        TreeMap<Object, Object> result = new TreeMap<Object, Object>();
        for (int i = 0; i < length; ++i) {
            Object key = this.read();
            Object value = this.read();
            result.put(key, value);
        }
        return result;
    }

    public byte[] readRawMap() throws IOException {
        Buffer buffer = new Buffer();
        int length = this.readMapHeader();
        buffer.append(new byte[]{(byte)Type.MAP.code, (byte)(0xFF & length >> 24), (byte)(0xFF & length >> 16), (byte)(0xFF & length >> 8), (byte)(0xFF & length)});
        for (int i = 0; i < length; ++i) {
            buffer.append(this.readRaw());
            buffer.append(this.readRaw());
        }
        return buffer.get();
    }

    public int readMapHeader() throws IOException {
        return this.in.readInt();
    }
}

