/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.contrib.util.typedbytes;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.hive.contrib.util.typedbytes.Type;
import org.apache.hadoop.hive.contrib.util.typedbytes.TypedBytesOutput;
import org.apache.hadoop.hive.contrib.util.typedbytes.TypedBytesRecordOutput;
import org.apache.hadoop.hive.contrib.util.typedbytes.TypedBytesWritable;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.SortedMapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VIntWritable;
import org.apache.hadoop.io.VLongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.record.Record;
import org.apache.hadoop.record.RecordOutput;

public class TypedBytesWritableOutput {
    private TypedBytesOutput out;
    private static ThreadLocal tbOut = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new TypedBytesWritableOutput();
        }
    };

    private TypedBytesWritableOutput() {
    }

    private void setTypedBytesOutput(TypedBytesOutput out) {
        this.out = out;
    }

    public static TypedBytesWritableOutput get(TypedBytesOutput out) {
        TypedBytesWritableOutput bout = (TypedBytesWritableOutput)tbOut.get();
        bout.setTypedBytesOutput(out);
        return bout;
    }

    public static TypedBytesWritableOutput get(DataOutput out) {
        return TypedBytesWritableOutput.get(TypedBytesOutput.get(out));
    }

    public TypedBytesWritableOutput(TypedBytesOutput out) {
        this();
        this.out = out;
    }

    public TypedBytesWritableOutput(DataOutput dout) {
        this(new TypedBytesOutput(dout));
    }

    public void write(Writable w) throws IOException {
        if (w instanceof TypedBytesWritable) {
            this.writeTypedBytes((TypedBytesWritable)w);
        } else if (w instanceof BytesWritable) {
            this.writeBytes((BytesWritable)w);
        } else if (w instanceof ByteWritable) {
            this.writeByte((ByteWritable)w);
        } else if (w instanceof BooleanWritable) {
            this.writeBoolean((BooleanWritable)w);
        } else if (w instanceof IntWritable) {
            this.writeInt((IntWritable)w);
        } else if (w instanceof VIntWritable) {
            this.writeVInt((VIntWritable)w);
        } else if (w instanceof LongWritable) {
            this.writeLong((LongWritable)w);
        } else if (w instanceof VLongWritable) {
            this.writeVLong((VLongWritable)w);
        } else if (w instanceof FloatWritable) {
            this.writeFloat((FloatWritable)w);
        } else if (w instanceof DoubleWritable) {
            this.writeDouble((DoubleWritable)w);
        } else if (w instanceof Text) {
            this.writeText((Text)w);
        } else if (w instanceof ShortWritable) {
            this.writeShort((ShortWritable)w);
        } else if (w instanceof ArrayWritable) {
            this.writeArray((ArrayWritable)w);
        } else if (w instanceof MapWritable) {
            this.writeMap((MapWritable)w);
        } else if (w instanceof SortedMapWritable) {
            this.writeSortedMap((SortedMapWritable)w);
        } else if (w instanceof Record) {
            this.writeRecord((Record)w);
        } else {
            this.writeWritable(w);
        }
    }

    public void writeTypedBytes(TypedBytesWritable tbw) throws IOException {
        this.out.writeRaw(tbw.get(), 0, tbw.getSize());
    }

    public void writeBytes(BytesWritable bw) throws IOException {
        byte[] bytes = Arrays.copyOfRange(bw.get(), 0, bw.getSize());
        this.out.writeBytes(bytes);
    }

    public void writeByte(ByteWritable bw) throws IOException {
        this.out.writeByte(bw.get());
    }

    public void writeBoolean(BooleanWritable bw) throws IOException {
        this.out.writeBool(bw.get());
    }

    public void writeInt(IntWritable iw) throws IOException {
        this.out.writeInt(iw.get());
    }

    public void writeVInt(VIntWritable viw) throws IOException {
        this.out.writeInt(viw.get());
    }

    public void writeLong(LongWritable lw) throws IOException {
        this.out.writeLong(lw.get());
    }

    public void writeVLong(VLongWritable vlw) throws IOException {
        this.out.writeLong(vlw.get());
    }

    public void writeFloat(FloatWritable fw) throws IOException {
        this.out.writeFloat(fw.get());
    }

    public void writeDouble(DoubleWritable dw) throws IOException {
        this.out.writeDouble(dw.get());
    }

    public void writeShort(ShortWritable sw) throws IOException {
        this.out.writeShort(sw.get());
    }

    public void writeText(Text t) throws IOException {
        this.out.writeString(t.toString());
    }

    public void writeArray(ArrayWritable aw) throws IOException {
        Writable[] writables = aw.get();
        this.out.writeVectorHeader(writables.length);
        for (Writable writable : writables) {
            this.write(writable);
        }
    }

    public void writeMap(MapWritable mw) throws IOException {
        this.out.writeMapHeader(mw.size());
        for (Map.Entry entry : mw.entrySet()) {
            this.write((Writable)entry.getKey());
            this.write((Writable)entry.getValue());
        }
    }

    public void writeSortedMap(SortedMapWritable smw) throws IOException {
        this.out.writeMapHeader(smw.size());
        for (Map.Entry entry : smw.entrySet()) {
            this.write((Writable)entry.getKey());
            this.write((Writable)entry.getValue());
        }
    }

    public void writeRecord(Record r) throws IOException {
        r.serialize((RecordOutput)TypedBytesRecordOutput.get(this.out));
    }

    public void writeWritable(Writable w) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        WritableUtils.writeString((DataOutput)dos, (String)w.getClass().getName());
        w.write((DataOutput)dos);
        dos.close();
        this.out.writeBytes(baos.toByteArray(), Type.WRITABLE.code);
    }

    public void writeEndOfRecord() throws IOException {
        this.out.writeEndOfRecord();
    }
}

